DROP TRIGGER DNS.AUTHENTICATION_LEVEL_TRGR;

CREATE OR REPLACE TRIGGER DNS.AUTHENTICATION_LEVEL_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON DNS.AUTHENTICATION_LEVEL
  REFERENCING OLD AS OLD NEW AS NEW
  for each row
declare
   	mDML char(1);
begin
  if DELETING then
	INSERT INTO AUTHENTICATION_LEVEL_H (
      AUTHENTICATION_LVL_H_ID,
      AUTHENTICATION_LEVEL_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      AUTHENTICATION_LEVEL_H_S.nextval
     ,:OLD.AUTHENTICATION_LEVEL_ID,
      :OLD.CODE,
      :OLD.NAME,
      :OLD.DESCRIPTION,
      :OLD.RECORD_CREATED_BY,
      :OLD.RECORD_CREATED_DATE,
      :OLD.RECORD_MODIFIED_BY,
      :OLD.RECORD_MODIFIED_DATE,
      :OLD.RECORD_MODIFIED_COUNT,
      'D',
      SYSDATE );
    else
	if UPDATING then
		mDML := 'U';
	else
		mDML := 'I';
	end if;

	INSERT INTO AUTHENTICATION_LEVEL_H (
      AUTHENTICATION_LVL_H_ID,
      AUTHENTICATION_LEVEL_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      AUTHENTICATION_LEVEL_H_S.nextval,
      :NEW.AUTHENTICATION_LEVEL_ID,
      :NEW.CODE,
      :NEW.NAME,
      :NEW.DESCRIPTION,
      :NEW.RECORD_CREATED_BY,
      :NEW.RECORD_CREATED_DATE,
      :NEW.RECORD_MODIFIED_BY,
      :NEW.RECORD_MODIFIED_DATE,
      :NEW.RECORD_MODIFIED_COUNT,
      mDML,
      SYSDATE );
  end if;

end AUTHENTICATION_LEVEL_TRGR;
/
DROP TRIGGER DNS.ENROLLMENT_FORM_TYPE_TRGR;

CREATE OR REPLACE TRIGGER DNS.ENROLLMENT_FORM_TYPE_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON DNS.ENROLLMENT_FORM_TYPE
  REFERENCING OLD AS OLD NEW AS NEW
  for each row
declare
   	mDML char(1);
begin
  if DELETING then
	INSERT INTO ENROLLMENT_FORM_TYPE_H (
      ENROLLMENT_FORM_TYP_H_ID,
      ENROLLMENT_FORM_TYPE_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      ENROLLMENT_FORM_TYPE_H_S.nextval,
      :OLD.ENROLLMENT_FORM_TYPE_ID,
      :OLD.CODE,
      :OLD.NAME,
      :OLD.DESCRIPTION,
      :OLD.RECORD_CREATED_BY,
      :OLD.RECORD_CREATED_DATE,
      :OLD.RECORD_MODIFIED_BY,
      :OLD.RECORD_MODIFIED_DATE,
      :OLD.RECORD_MODIFIED_COUNT,
      'D',
      SYSDATE );
    else
	if UPDATING then
		mDML := 'U';
	else
		mDML := 'I';
	end if;

	INSERT INTO ENROLLMENT_FORM_TYPE_H (
      ENROLLMENT_FORM_TYP_H_ID,
      ENROLLMENT_FORM_TYPE_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      ENROLLMENT_FORM_TYPE_H_S.nextval,
      :NEW.ENROLLMENT_FORM_TYPE_ID,
      :NEW.CODE,
      :NEW.NAME,
      :NEW.DESCRIPTION,
      :NEW.RECORD_CREATED_BY,
      :NEW.RECORD_CREATED_DATE,
      :NEW.RECORD_MODIFIED_BY,
      :NEW.RECORD_MODIFIED_DATE,
      :NEW.RECORD_MODIFIED_COUNT,
      mDML,
      SYSDATE );
  end if;

end ENROLLMENT_FORM_TYPE_TRGR;
/
DROP TRIGGER DNS.DNS_ENROLLMENT_APP_STATUS_TRGR;

CREATE OR REPLACE TRIGGER DNS.DNS_ENROLLMENT_APP_STATUS_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON DNS.DNS_ENROLLMENT_APP_STATUS
  REFERENCING OLD AS OLD NEW AS NEW
  for each row
declare
   	mDML char(1);
begin
  if DELETING then
	INSERT INTO DNS_ENROLLMENT_APP_STATUS_H (
      DNS_ENROLLMENT_APP_STAT_H_ID,
      DNS_ENROLLMENT_APP_STATUS_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      DNS_ENROLLMENT_APP_STATUS_H_S.nextval,
      :OLD.DNS_ENROLLMENT_APP_STATUS_ID,
      :OLD.CODE,
      :OLD.NAME,
      :OLD.DESCRIPTION,
      :OLD.RECORD_CREATED_BY,
      :OLD.RECORD_CREATED_DATE,
      :OLD.RECORD_MODIFIED_BY,
      :OLD.RECORD_MODIFIED_DATE,
      :OLD.RECORD_MODIFIED_COUNT,
      'D',
      SYSDATE );
    else
	if UPDATING then
		mDML := 'U';
	else
		mDML := 'I';
	end if;

	INSERT INTO DNS_ENROLLMENT_APP_STATUS_H (
      DNS_ENROLLMENT_APP_STAT_H_ID,
      DNS_ENROLLMENT_APP_STATUS_ID,
      CODE,
      NAME,
      DESCRIPTION,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE )
    VALUES (
      DNS_ENROLLMENT_APP_STATUS_H_S.nextval,
      :NEW.DNS_ENROLLMENT_APP_STATUS_ID,
      :NEW.CODE,
      :NEW.NAME,
      :NEW.DESCRIPTION,
      :NEW.RECORD_CREATED_BY,
      :NEW.RECORD_CREATED_DATE,
      :NEW.RECORD_MODIFIED_BY,
      :NEW.RECORD_MODIFIED_DATE,
      :NEW.RECORD_MODIFIED_COUNT,
      mDML,
      SYSDATE );
  end if;

end DNS_ENROLLMENT_APP_STATUS_TRGR;
/
DROP TRIGGER DNS.DNS_ENROLL_APP_TRGR;

CREATE OR REPLACE TRIGGER DNS.DNS_ENROLL_APP_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON DNS.DNS_ENROLLMENT_APPLICATION
  REFERENCING OLD AS OLD NEW AS NEW
  for each row
declare
    mDML char(1);
begin
  if DELETING then
  INSERT INTO DNS_ENROLLMENT_APPLICATION_H (
      DNS_ENROLLMENT_APP_H_ID,
      DNS_ENROLLMENT_APP_ID,
      PERSON_ID,
      DNS_ENROLLMENT_APP_STATUS_ID,
      ENROLLMENT_FORM_TYPE_ID,
      AUTHENTICATION_LEVEL_ID,
      VETERAN_IDENTIFIER_TYPE_ID,
      APPLICANT_LAST_NAME,
      APPLICANT_FIRST_NAME,
      APPLICANT_MIDDLE_NAME,
      APPLICANT_DOB,
      APPLICANT_SSN,
      STD_GENDER_ID,
      RESPONSE_TIMESTAMP,
      ERROR_TEXT,
      FULLY_QUALIFIED_ID,
      PREFERRED_FACILITY_ID,
      REQUEST_RECEIVED_TIMESTAMP,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE,
      BF_PROCESSED)
    VALUES (
      DNS_ENROLLMENT_APPLICATION_H_S.nextval,
      :OLD.DNS_ENROLLMENT_APP_ID,
      :OLD.PERSON_ID,
      :OLD.DNS_ENROLLMENT_APP_STATUS_ID,
      :OLD.ENROLLMENT_FORM_TYPE_ID,
      :OLD.AUTHENTICATION_LEVEL_ID,
      :OLD.VETERAN_IDENTIFIER_TYPE_ID,
      :OLD.APPLICANT_LAST_NAME,
      :OLD.APPLICANT_FIRST_NAME,
      :OLD.APPLICANT_MIDDLE_NAME,
      :OLD.APPLICANT_DOB,
      :OLD.APPLICANT_SSN,
      :OLD.STD_GENDER_ID,
      :OLD.RESPONSE_TIMESTAMP,
      :OLD.ERROR_TEXT,
      :OLD.FULLY_QUALIFIED_ID,
      :OLD.PREFERRED_FACILITY_ID,
      :OLD.REQUEST_RECEIVED_TIMESTAMP,
      :OLD.RECORD_CREATED_BY,
      :OLD.RECORD_CREATED_DATE,
      :OLD.RECORD_MODIFIED_BY,
      :OLD.RECORD_MODIFIED_DATE,
      :OLD.RECORD_MODIFIED_COUNT,
      'D',
      SYSDATE,
      :OLD.BF_PROCESSED);
    else
  if UPDATING then
    mDML := 'U';
  else
    mDML := 'I';
  end if;

  INSERT INTO DNS_ENROLLMENT_APPLICATION_H (
      DNS_ENROLLMENT_APP_H_ID,
      DNS_ENROLLMENT_APP_ID,
      PERSON_ID,
      DNS_ENROLLMENT_APP_STATUS_ID,
      ENROLLMENT_FORM_TYPE_ID,
      AUTHENTICATION_LEVEL_ID,
      VETERAN_IDENTIFIER_TYPE_ID,
      APPLICANT_LAST_NAME,
      APPLICANT_FIRST_NAME,
      APPLICANT_MIDDLE_NAME,
      APPLICANT_DOB,
      APPLICANT_SSN,
      STD_GENDER_ID,
      RESPONSE_TIMESTAMP,
      ERROR_TEXT,
      FULLY_QUALIFIED_ID,
      PREFERRED_FACILITY_ID,
      REQUEST_RECEIVED_TIMESTAMP,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      TRANSACTION_TYPE_CODE,
      HISTORY_CREATED_DATE,
      BF_PROCESSED)
    VALUES (
      DNS_ENROLLMENT_APPLICATION_H_S.nextval,
      :NEW.DNS_ENROLLMENT_APP_ID,
      :NEW.PERSON_ID,
      :NEW.DNS_ENROLLMENT_APP_STATUS_ID,
      :NEW.ENROLLMENT_FORM_TYPE_ID,
      :NEW.AUTHENTICATION_LEVEL_ID,
      :NEW.VETERAN_IDENTIFIER_TYPE_ID,
      :NEW.APPLICANT_LAST_NAME,
      :NEW.APPLICANT_FIRST_NAME,
      :NEW.APPLICANT_MIDDLE_NAME,
      :NEW.APPLICANT_DOB,
      :NEW.APPLICANT_SSN,
      :NEW.STD_GENDER_ID,
      :NEW.RESPONSE_TIMESTAMP,
      :NEW.ERROR_TEXT,
      :NEW.FULLY_QUALIFIED_ID,
      :NEW.PREFERRED_FACILITY_ID,
      :NEW.REQUEST_RECEIVED_TIMESTAMP,
      :NEW.RECORD_CREATED_BY,
      :NEW.RECORD_CREATED_DATE,
      :NEW.RECORD_MODIFIED_BY,
      :NEW.RECORD_MODIFIED_DATE,
      :NEW.RECORD_MODIFIED_COUNT,
      mDML,
      SYSDATE,
      :NEW.BF_PROCESSED);
  end if;

end DNS_ENROLL_APP_TRGR;
/
